# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from rasp_vault.api import get_secret

from common.settings import *  # noqa
from common.settings import COMMON_CONTRIB_APPS, COMMON_INSTALLED_APPS
from common.settings.configuration import BaseConfigurator, Configuration
from common.settings.utils import get_fallback_conf_from_str

DEBUG = False
TEMPLATE_DEBUG = DEBUG

# If you set this to False, Django will not use timezone-aware datetimes.
USE_TZ = False


INSTALLED_APPS = COMMON_CONTRIB_APPS + COMMON_INSTALLED_APPS + [
    'travel.rasp.suburban_tasks.suburban_tasks.apps.SuburbanTasksAppConfig',
]

PROJECT_PATH = os.path.abspath(os.path.join(os.path.dirname(__file__), ''))

DATABASE_ROUTERS = ['travel.rasp.suburban_tasks.suburban_tasks.db_router.DbRouter']
MYSQL_RZD_DB_ALIAS = 'rasp_rzd'


def get_rzd_hosts_from_env():
    rzd_proxies = []
    for i in range(1, 10):
        port_host = os.environ.get('RASP_RZD_PROXY{}'.format(i))
        if port_host:
            host, port = port_host.split(':')
            rzd_proxies.append((host, port))

    return rzd_proxies

RZD_HOSTS = get_rzd_hosts_from_env()

RZD_PORT = 666
RZD_DATABASE_NAME = 'DB2D'
RZD_SUBURBAN_EVENTS_DB = 'DF1P'

MYSQL_CONNECT_TIMEOUT = 10
MYSQL_READ_TIMEOUT = 5000
MYSQL_WRITE_TIMEOUT = 5000

SQS_ACCESS_KEY = 'rasp'  # используем продакшн аккаунт SQS для пересылки из прода rzd событий в тестинг

SUBURBAN_EVENTS_SEND_TO_SQS = os.environ.get('RASP_SUBURBAN_EVENTS_SEND_TO_SQS', False)
SUBURBAN_EVENTS_QUEUE_MAX_BATCH_SIZE = 200
SUBURBAN_EVENTS_QUEUE_NAME = 'rzd_events'


class RZDBufferConfigurator(BaseConfigurator):
    def apply_base(self, settings):
        settings['MONGO_DATABASES']['default'].setdefault('options', {}).update({
            'socketTimeoutMS': None,
            'connectTimeoutMS': 20000,
            'serverSelectionTimeoutMS': 30000
        })

    def apply_development(self, settings):
        settings['DATABASES'][settings['MYSQL_RZD_DB_ALIAS']] = {
            'HOST': '127.0.0.1',
            'PORT': int(os.getenv('TRAVEL_MYSQL_RECIPE_PORT', '3306')),
            'USER': 'rasp',
            'PASSWORD': 'rasp',
            'NAME': 'rasp_rzd',
            'ENGINE': 'common.db.backends.mysql',
            'STORAGE_ENGINE': 'InnoDB',
        }

    def apply_production(self, settings):
        self._apply_mdb_db(settings, 'rasp-rzd-buffer-production')
        settings['RZD_DATABASE_NAME'] = 'DB2P'
        settings['SUBURBAN_EVENTS_SEND_TO_SERVER'] = 'https://testing.suburban-tasks.rasp.common.yandex.net'

    def apply_testing(self, settings):
        self._apply_mdb_db(settings, 'rasp-rzd-buffer-testing')

    def _apply_mdb_db(self, settings, secret_name):
        secret = get_secret(secret_name)

        settings['DATABASES'][settings['MYSQL_RZD_DB_ALIAS']] = {
            'ENGINE': 'travel.rasp.library.python.common23.db.backends.cluster_mdb',
            'STORAGE_ENGINE': 'InnoDB',
            'NAME': 'rasp_rzd',
            'USER': secret['RASP_MDB_RZD_DB_USER'],
            'PASSWORD': secret['RASP_MDB_RZD_DB_PASSWORD'],
            'CLUSTER': {
                'CLUSTER_ID': secret['RASP_MDB_RZD_DB_CLUSTER_ID'],
                'FALLBACK': get_fallback_conf_from_str(secret['RASP_MDB_RZD_DB_FALLBACK']),
                'MDB_API_CALL_ENABLED': False,
                'USE_MASTER': True,
                'USE_REPLICAS': False,
                'CHECK_MASTER_ON_EACH_CONNECT': True,
            }
        }


Configuration.configurator_classes += [RZDBufferConfigurator]
