# -*- coding: utf8 -*-

# FIXME: Вынести из админки в common, а тут удалить
import inspect
import logging
import random
import sys
import os
import time as os_time
from datetime import timedelta
from itertools import islice
from math import floor

from django.conf import settings

from common.models_utils import take
from common.utils.fileutils import get_project_relative_path, get_my_caller_file


def chunker(iterable, chunk_size):
    iterator = iter(iterable)
    while True:
        chunk = list(islice(iterator, chunk_size))
        if chunk:
            yield chunk
        else:
            break


class PercentageStatus(object):
    u"""
    Класс который позволяет считать в процентах, оставшееся время.
    Счетчик приспособлен для целых чисел, хотя возможно будет работать и с float
    """
    def __init__(self, total, log=None, show_elapsed=True, show_remained=True,
                 callback=None, print_to_stream=None, title=u''):
        u"""
        @param total: всего элементов или событий,
        @param log: лог куда будет писаться процентовка,
        @param show_elapsed: записывать в лог сколько прошло времени,
        @param show_remained: записывать в лог сколько примерно осталось времени,
        @param callback: функция, которая будет вызываться при смене процента,
            в качестве аргумента функция должна принимать объект типа PercentageStatus.
            Так же функции можно передать дополнительные аргументы в step.
        """
        self.total = total if total > 0 else False
        self.log = log
        self.show_elapsed = show_elapsed
        self.show_remained = show_remained
        self.callback = callback
        self.start_time = os_time.time()
        self.previous_pos = 0
        self.previous_persantage = 0
        self.pos = 0
        self.persentage = 0
        self.print_to_stream = print_to_stream
        self.title = title

    def restart(self):
        u"""
        Сбросить статус, и начать отсчет заново.
        """
        self.start_time = os_time.time()
        self.pos = 0
        self.persantage = 0
        self.previous_pos = 0
        self.previous_persantage = 0

    def status_changed(self):
        return floor(self.persantage) != floor(self.previous_persantage) or \
            self.pos == self.total

    def step(self, increment=1, *args, **kwargs):
        u"""
        @param increment: увеличить счетчик на эту величину, по умолчанию 1.
        Так же можно передать параметры для callback.
        """
        if not self.total:
            return
        self.pos = self.previous_pos + increment
        self.persantage = 100.0 * self.pos / self.total
        # Сменилась процентовка, пишем в лог
        if self.status_changed():
            self.time_elapsed = os_time.time() - self.start_time
            self.time_per_item = self.time_elapsed / self.pos
            self.time_remained = self.time_per_item * self.total - self.time_elapsed
            self.timedelta_elapsed = timedelta(seconds=int(self.time_elapsed))
            self.timedelta_remained = timedelta(seconds=int(self.time_remained))

            if self.log or self.print_to_stream:
                format = []
                if self.title:
                    format = [self.title]

                format += [u"Progress:%(persantage)4.0f%%"]
                if self.show_elapsed:
                    format += [u"Elapsed: %(timedelta_elapsed)s"]
                if self.show_remained:
                    format += [u"Remained: %(timedelta_remained)s"]
                format = u". ".join(format)
                if self.log:
                    self.log.info(format, vars(self))
                if self.print_to_stream:
                    print >> self.print_to_stream, format % vars(self)

            if callable(self.callback):
                self.callback(self, *args, **kwargs)

        self.previous_pos = self.pos
        self.previous_persantage = self.persantage


def add_stdout_handler(log, format=None):
    format = format or settings.LOG_FORMAT
    """Добавляем handler для stdout, если еще не добавлен"""
    # Проверяем есть ли у нас handler который пишет в stdout
    add_stream_handler(log, sys.stdout, format)


def print_log_to_stdout(log=''):
    add_stdout_handler(log)


def add_stream_handler(log, stream, format=None, filters=None):
    """Добавляем handler для stream, если еще не добавлен"""

    format = format or settings.LOG_FORMAT

    log = _get_log_from_string_or_log_instance(log)
    filters = filters or []

    for handler in log.handlers:
        if isinstance(handler, logging.StreamHandler) and handler.stream == stream:
            return

    stream_handler = logging.StreamHandler(stream)
    stream_handler.setFormatter(logging.Formatter(format))

    for log_filter in filters:
        stream_handler.addFilter(log_filter)

    log.addHandler(stream_handler)


def _get_log_from_string_or_log_instance(log_or_logname):
    if isinstance(log_or_logname, basestring):
        return logging.getLogger(log_or_logname)
    else:
        return log_or_logname


FORMAT_PARAM = '_format'
COLUMNS_PARAM = '_columns'
ENCODING_PARAM = '_encoding'
LIMIT_PARAM = '_limit'
BOOLEAN_FORMAT = '_boolean_format'
DEFAULT_BOOLEAN_FORMAT = 'int'
IGNORED_PARAMS = (FORMAT_PARAM, COLUMNS_PARAM, ENCODING_PARAM, LIMIT_PARAM, BOOLEAN_FORMAT)
DEFAULT_FORMAT = 'csv'
DEFAULT_ENCODING = 'utf-8'


def get_script_logger():
    stack = inspect.stack()
    caller_file_path = get_my_caller_file(stack)
    script_path = get_project_relative_path(caller_file_path)

    base_file_path, _ext = os.path.splitext(script_path)
    module_name = base_file_path.replace('/', '.')

    return logging.getLogger(module_name)


def create_script_run_log(script_log_name, format=None, capture_stdstreams=False):
    from django.conf import settings
    from travel.rasp.library.python.common23.date.environment import now
    format = format or settings.LOG_FORMAT

    path = os.path.join(settings.LOG_PATH, 'script_runs', *script_log_name.split('.'))
    path = os.path.join(path, now().strftime('%Y-%m-%d_%H%M%S.log'))

    if not os.path.exists(os.path.dirname(path)):
        os.makedirs(os.path.dirname(path))

    handler = logging.FileHandler(path)
    handler.setFormatter(logging.Formatter(format))

    log = logging.getLogger()
    log.addHandler(handler)

    if capture_stdstreams:
        capture_stdstreams_to_file(handler.stream)

    return handler.stream


def capture_stdstreams_to_file(file):
    """
    Перенаправляем стандартные потоки в этот файл
    """
    fd = file.fileno()

    sys.stdout.flush()
    os.close(1)
    os.dup2(fd, 1)

    sys.stderr.flush()
    os.close(2)
    os.dup2(fd, 2)


def model_iter(qs, chunksize=100, in_chunks=False, shuffle=False, plain_qs=None):
    pks = list(qs.values_list('pk', flat=True))

    if shuffle:
        random.shuffle(pks)

    plain_qs = plain_qs if plain_qs is not None else qs.all().order_by()

    if chunksize == 1:
        for pk in pks:
            yield plain_qs.get(pk=pk)

        return

    pks_iter = iter(pks)

    while 1:
        pks = take(chunksize, pks_iter)

        if not pks:
            break

        objects = plain_qs.in_bulk(pks)

        if in_chunks:
            yield [objects[pk] for pk in pks if pk in objects]
        else:
            for pk in pks:
                try:
                    yield objects[pk]
                except KeyError:
                    raise
