# coding: utf8
from django.conf import settings


class DbRouter(object):
    def get_db_alias_for_app(self, app_label):
        if app_label in ['rzd_buffer']:
            return settings.MYSQL_RZD_DB_ALIAS
        else:
            return None

    def db_for_read(self, model, **hints):
        return self.get_db_alias_for_app(model._meta.app_label)

    def db_for_write(self, model, **hints):
        return self.get_db_alias_for_app(model._meta.app_label)

    def allow_migrate(self, db, app_label, model_name=None, **hints):
        # проводим миграции только для ржд-базы
        if db != settings.MYSQL_RZD_DB_ALIAS:
            return False

        return self.get_db_alias_for_app(app_label) == settings.MYSQL_RZD_DB_ALIAS
