# -*- coding: utf-8 -*-
from __future__ import unicode_literals, print_function

from django.db import migrations, models


def drop_old_indexes(apps, schema_editor):
    cursor = schema_editor.connection.cursor()
    has_index_sql = 'SELECT * FROM information_schema.statistics WHERE table_schema=DATABASE() AND INDEX_NAME = %s' \
                    ' AND TABLE_NAME = %s'

    index_names = [
        ('rzd_buffer_current_scalendar_IDTR_CDATE', 'rzd_buffer_current_scalendar'),
        ('rzd_buffer_change_spec_buf_ID_XML', 'rzd_buffer_change_spec_buf'),
        ('rzd_buffer_current_strains_IDTR', 'rzd_buffer_current_strains'),
        ('rzd_buffer_current_strainsvar_IDR', 'rzd_buffer_current_strainsvar'),
        ('rzd_buffer_change_scalendar_buf_ID_XML', 'rzd_buffer_change_scalendar_buf'),
        ('rzd_buffer_current_srasprp_IDR', 'rzd_buffer_current_srasprp'),
        ('rzd_buffer_change_srasprp_buf_IDR', 'rzd_buffer_change_srasprp_buf'),
        ('rzd_buffer_change_srasprp_buf_ID_XML', 'rzd_buffer_change_srasprp_buf'),
    ]

    for index_name, table_name in index_names:
        cursor.execute(has_index_sql, [index_name, table_name])
        if cursor.fetchall():
            print('Нашли индекс', index_name, 'удаляем его')
            schema_editor.execute(schema_editor.sql_delete_index % dict(
                name=schema_editor.quote_name(index_name),
                table=schema_editor.quote_name(table_name),
            ))
        else:
            print('!!! Не найден индекс', index_name)


class Migration(migrations.Migration):

    dependencies = [
        ('rzd_buffer', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(drop_old_indexes, migrations.RunPython.noop),
        migrations.AlterField(
            model_name='change_scalendar_buf',
            name='ID_XML',
            field=models.IntegerField(help_text='\n    Идентификатор корректировочного сообщения.\n    Целое число, однозначно идентифицирующее корректировочный документ.\n', db_index=True),
        ),
        migrations.AlterField(
            model_name='change_spec_buf',
            name='ID_XML',
            field=models.IntegerField(help_text='\n        Идентификатор XML-документа\n    ', db_index=True),
        ),
        migrations.AlterField(
            model_name='change_srasprp_buf',
            name='IDR',
            field=models.IntegerField(help_text='\n        Идентификатор расписания, действующего для данного поезда в данную дату. =0, если поезд в данный день не ходит.\n    ', db_index=True),
        ),
        migrations.AlterField(
            model_name='change_srasprp_buf',
            name='ID_XML',
            field=models.IntegerField(help_text='\n    Идентификатор корректировочного сообщения.\n    Целое число, однозначно идентифицирующее корректировочный документ.\n', db_index=True),
        ),
        migrations.AlterField(
            model_name='change_strains_buf',
            name='IDTR',
            field=models.IntegerField(help_text='\n    Идентификатор корректировочного сообщения.\n    Целое число, однозначно идентифицирующее корректировочный документ.\n', db_index=True),
        ),
        migrations.AlterField(
            model_name='change_strainsvar_buf',
            name='IDR',
            field=models.IntegerField(help_text='\n        Идентификатор расписания.\n        Абстрактный числовой ключ расписания в БД.\n    ', db_index=True),
        ),
        migrations.AlterField(
            model_name='current_srasprp',
            name='IDR',
            field=models.IntegerField(help_text='\n        Идентификатор расписания, действующего для данного поезда в данную дату. =0, если поезд в данный день не ходит.\n    ', db_index=True),
        ),
        migrations.AlterField(
            model_name='current_strains',
            name='IDTR',
            field=models.IntegerField(help_text='\n    Идентификатор корректировочного сообщения.\n    Целое число, однозначно идентифицирующее корректировочный документ.\n', db_index=True),
        ),
        migrations.AlterField(
            model_name='current_strainsvar',
            name='IDR',
            field=models.IntegerField(help_text='\n        Идентификатор расписания.\n        Абстрактный числовой ключ расписания в БД.\n    ', db_index=True),
        ),
        migrations.AlterField(
            model_name='full_srasprp',
            name='IDR',
            field=models.IntegerField(help_text='\n        Идентификатор расписания, действующего для данного поезда в данную дату. =0, если поезд в данный день не ходит.\n    ', db_index=True),
        ),
        migrations.AlterField(
            model_name='full_strains',
            name='IDTR',
            field=models.IntegerField(help_text='\n    Идентификатор корректировочного сообщения.\n    Целое число, однозначно идентифицирующее корректировочный документ.\n', db_index=True),
        ),
        migrations.AlterField(
            model_name='full_strainsvar',
            name='IDR',
            field=models.IntegerField(help_text='\n        Идентификатор расписания.\n        Абстрактный числовой ключ расписания в БД.\n    ', db_index=True),
        ),
        migrations.AlterIndexTogether(
            name='change_scalendar_buf',
            index_together=set([('IDTR', 'CDATE')]),
        ),
        migrations.AlterIndexTogether(
            name='current_scalendar',
            index_together=set([('IDTR', 'CDATE')]),
        ),
        migrations.AlterIndexTogether(
            name='full_scalendar',
            index_together=set([('IDTR', 'CDATE')]),
        ),
    ]
