# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('rzd_buffer', '0004_af_fields_user_and_time'),
    ]

    operations = [
        migrations.CreateModel(
            name='LVGD01_TR2PROC',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('ID_TRAIN', models.IntegerField(help_text='\n        Идентификатор отправившегося поезда - все его события будут иметь один ID_TRAIN.'
                                                           '\n        Когда этот же поезд отправится завтра - ID_TRAIN поменяется'
                                                           '\n        Оригинальное название колонки в базе РЖД - ID\n    ')),
                ('IDTR', models.IntegerField(help_text='\n        Идентификатор поезда из НГДП\n    ')),
                ('IDRASP', models.IntegerField(help_text='\n        Идентификатор расписания назначенного поезда из НГДП\n    ')),
                ('STORASP', models.IntegerField(help_text='\n        Код станции отправления\n    ')),
                ('STOEX', models.IntegerField(help_text='\n        Код станции отправления ЭКСПРЕСС\n    ')),
                ('NAMESTO', models.CharField(help_text='\n        Наименование станции отправления\n    ', max_length=100)),
                ('STNRASP', models.IntegerField(help_text='\n        Код станции назначения\n    ')),
                ('STNEX', models.IntegerField(help_text='\n        Код станции назначения ЭКСПРЕСС\n    ')),
                ('NAMESTN', models.CharField(help_text='\n        Наименование станции назначения\n    ', max_length=100)),
                ('NOMPEX', models.CharField(help_text='\n        \u2116 поезда в системе ЭКСПРЕСС\n    ', max_length=100)),
                ('NAMEP', models.CharField(help_text='\n        Наименование поезда\n    ', max_length=100)),
                ('SOURCE', models.IntegerField(help_text='\n        Система \u2013 источник информации. 1 \u2013 АСОУП, 2 \u2013 ГИД Урал, 3 \u2013 САИ ПС, 4 \u2013 ГИС РЖД\n    ')),
                ('KODOP', models.IntegerField(help_text='\n        Код операции с поездом. 1 \u2013 прибытие, 3 \u2013 отправление\n    ')),
                ('DOR', models.IntegerField(help_text='\n        Код дороги ввода информации\n    ')),
                ('OTD', models.IntegerField(help_text='\n        Код отделения\n    ')),
                ('NOMRP', models.IntegerField(help_text='\n        Порядковый номер станции по ходу поезда\n    ')),
                ('STOPER', models.IntegerField(help_text='\n        Порядковый номер станции по ходу поезда\n    ')),
                ('STOPEREX', models.IntegerField(help_text='\n        Код станции совершения операции ЭКСПРЕСС\n    ')),
                ('STNAME', models.CharField(help_text='\n        Наименование станции совершения операции\n    ', max_length=100)),
                ('TIMEOPER_N', models.DateTimeField(help_text='\n        Дата и время совершения операции с поездом из эталонного расписания\n    ')),
                ('TIMEOPER_F', models.DateTimeField(help_text='\n        Дата и время совершения операции с поездом фактические\n    ')),
                ('KM', models.IntegerField(help_text='\n        Километраж от начала маршрута\n    ')),
                ('PRSTOP', models.FloatField(help_text='\n        Признак стоянки без посадки/высадки пассажиров.'
                                                       '\n        1-стоянка без посадки/высадки; 0\u2013обычный режим'
                                                       '\n        Признак стоянки без посадки/высадки пассажиров означает следующее: если время стоянки не равно 0 и признак 0 \u2013'
                                                       '\n        посадка/высадка есть, признак 1 \u2013 посадки/высадки нет; если время стоянки равно 0, признак не надо анализировать\n    ')),
                ('PRIORITY', models.FloatField(help_text='\n        Приоритетная запись о фактическом маршруте\n    ')),
                ('PRIORITY_RATING', models.FloatField(help_text='\n        Рейтинг системы-источника в таблице приоритетов\n    ')),
            ],
            options={
                'verbose_name': 'Данные о прохождении электричек (LVGD01_TR2PROC)',
                'verbose_name_plural': 'Данные о прохождении электричек (LVGD01_TR2PROC)',
            },
        ),
        migrations.CreateModel(
            name='LVGD01_TR2PROC_query',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('queried_at', models.DateTimeField(help_text='\n        Во сколько сделан запрос (Europe/Moscow)\n    ', db_index=True)),
                ('query_from', models.DateTimeField(help_text='Параметр DTFROM, переданный при запросе')),
                ('query_to', models.DateTimeField(help_text='Параметр DTTO, переданный при запросе')),
                ('rows_count', models.IntegerField(default=0, help_text='Количество строк в ответе')),
                ('exception', models.TextField(help_text='Текст ошибки, если была')),
            ],
            options={
                'verbose_name': 'Данные о прохождении электричек (LVGD01_TR2PROC) - лог',
                'verbose_name_plural': 'Данные о прохождении электричек (LVGD01_TR2PROC) - логи',
            },
        ),
        migrations.AddField(
            model_name='lvgd01_tr2proc',
            name='query',
            field=models.ForeignKey(to='rzd_buffer.LVGD01_TR2PROC_query'),
        ),
    ]
