# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from retry import retry
from django.conf import settings

from travel.library.python.yp.endpoints import YpEndpoints
from common.settings.utils import define_setting


log = logging.getLogger(__name__)

define_setting('ENABLE_GET_RZD_HOSTS_FROM_YP', default=True)
define_setting('YA_DEPLOY_RZD_ENTRYPOINT', default='rzd_proxy.DeployUnit1')

CLIENT_NAME_FOR_YP = 'suburban_tasks'


@retry(tries=2, delay=5)
def get_hosts_from_yp():
    return YpEndpoints(CLIENT_NAME_FOR_YP, settings.YA_DEPLOY_RZD_ENTRYPOINT).get_hosts()


def get_rzd_hosts_and_ports():
    rzd_hosts_and_ports = None

    if settings.ENABLE_GET_RZD_HOSTS_FROM_YP:
        try:
            rzd_hosts = get_hosts_from_yp()
        except Exception:
            log.exception("Can't get hosts from YP endpoints")
        else:
            # TODO: remove condition by .man.yp-c after datacenter issues resolved
            rzd_hosts_and_ports = [(host, settings.RZD_PORT) for host in rzd_hosts if ".man.yp-c" not in host]

    if not rzd_hosts_and_ports:
        rzd_hosts_and_ports = settings.RZD_HOSTS

    if not rzd_hosts_and_ports:
        log.error('No rzd proxies found')

    return rzd_hosts_and_ports
