# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

import mongolock
from django.conf import settings

from common.utils.lock import lock

from travel.rasp.suburban_tasks.suburban_tasks.scripts.update_suburban_events import read_rows_from_sqs


log = logging.getLogger(__name__)


def run():
    try:
        with lock('lock_fetch_events_from_sqs', 'suburban_events_process',
                  database_name=settings.SUBURBAN_EVENTS_DATABASE_NAME):
            read_rows_from_sqs()
    except mongolock.MongoLockLocked as ex:
        log.debug('Can not get lock: %s', repr(ex))


if __name__ == '__main__':
    run()
