# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os

from django.conf import settings

from travel.rasp.library.python.common23.data_api.juggler.juggler import CheckError, CRIT, WARN, get_events, send_events
from travel.rasp.suburban_tasks.suburban_tasks.rzd_hosts import get_rzd_hosts_and_ports
from travel.rasp.suburban_tasks.suburban_tasks.rzd_utils import get_raw_connection


# TODO: return 3 after datacenter issues resolved
RZD_PROXIES_EXPECTED_COUNT = 2


def check_rzd_proxy_alive():
    working, broken = [], []
    for host, port in get_rzd_hosts_and_ports():
        try:
            get_raw_connection(host, port, db_name=settings.RZD_SUBURBAN_EVENTS_DB)
        except Exception as ex:
            broken.append([host, port, repr(ex)])
        else:
            working.append([host, port])

    working_msgs = ['Rzd proxy works: {}:{}'.format(host, port) for host, port in working]
    if broken:
        broken_msgs = ['Rzd proxy is broken: {}:{} -> {}'.format(host, port, err) for host, port, err in broken]
        msg = '; \n'.join(broken_msgs + working_msgs)
        raise CheckError(CRIT, msg)
    elif not working:
        raise CheckError(CRIT, 'No rzd proxy hosts at all')
    elif len(working) < RZD_PROXIES_EXPECTED_COUNT:
        raise CheckError(
            WARN,
            'Only {} rzd proxies known, but should be {} proxies\n'.format(len(working), RZD_PROXIES_EXPECTED_COUNT) + '; \n'.join(working_msgs)
        )
    else:
        return '\n' + '; \n'.join(working_msgs)


def run():
    tags = ['rzd']
    events = get_events([
        ('rzd-proxy-alive', check_rzd_proxy_alive, tags),
    ])

    if 'SANDBOX_CONFIG' in os.environ:
        for event in events:
            event.host = 'RaspRzdTask'

    send_events(events)


if __name__ == '__main__':
    run()
