# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from datetime import timedelta
from operator import itemgetter, attrgetter


def format_dates(dates):
    if not dates:
        return u'[]'

    dates = list(sorted(dates))

    if len(dates) <= 5:
        return u', '.join(d.strftime('%Y-%m-%d') for d in dates)

    current = dates[0]
    ranges = [[current, None]]
    for day in dates[1:]:
        if day - timedelta(1) != current:
            ranges[-1][1] = current
            ranges.append([day, None])

        current = day

    if ranges[-1][1] is None:
        ranges[-1][1] = current
    else:
        ranges.append([current, current])

    if len(ranges) > 5:
        return u'{:%Y-%m-%d} ..... {:%Y-%m-%d}: всего {}'.format(dates[0], dates[-1], len(dates))

    return u', '.join(
        r[0].strftime('%Y-%m-%d') if r[0] == r[1] else u'{:%Y-%m-%d}..{:%Y-%m-%d}'.format(r[0], r[-1])
        for r in ranges
    )


SPEC_BUF_KEY_FIELDS = ['ID_XML', 'DATE_GVC']


def build_spec_buf_key(buf_object):
    """
    Уникальный ключ изменения SPEC_BUF, этот ключ можно получить у любой буферной таблицы.
    По этому ключу буферные таблицы однозначно привязываются к записи из SPEC_BUF
    """
    key_format = '{}_{:%Y-%m-%d %H:%M:%S}'

    if isinstance(buf_object, dict):
        return key_format.format(*itemgetter(*SPEC_BUF_KEY_FIELDS)(buf_object))
    else:
        return key_format.format(*attrgetter(*SPEC_BUF_KEY_FIELDS)(buf_object))
