# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os  # noqa

from settings import *  # noqa
from common.settings.configuration import Configuration, BaseConfigurator
from common.settings.utils import configure_raven, get_app_version
from travel.rasp.library.python.common23.logging.configure import configure_default_logging

PKG_VERSION = '11'
PACKAGE = 'suburban-widget'
LOG_PATH = '/var/log/app'
CACHEROOT = '/yandex/rasp-%s/%s/' % (PACKAGE, PKG_VERSION)
SUPPORTED_DOMAINS = ['ru', 'ua']

PKG_VERSION = get_app_version()


class SuburbanWidgetConfigurator(BaseConfigurator):
    def apply_base(self, settings):
        self.setup_logging(settings)

    def apply_production(self, settings):
        configure_raven(settings, 'suburban_widget')

    def apply_testing(self, settings):
        configure_raven(settings, 'suburban_widget')

    def setup_logging(self, settings, base_log_level=None):
        settings['LOGGING'] = configure_default_logging(settings, base_log_level=base_log_level)


Configuration.configurator_classes += [SuburbanWidgetConfigurator]

Configuration().apply(globals())

env_suffix = ''

yandex_environment_type = globals()['YANDEX_ENVIRONMENT_TYPE']

if yandex_environment_type in ['testing', 'stress']:
    env_suffix = '-testing'
    SUPPORTED_HOSTS = ['suburban-widget.rasp.lepus.yandex.%s' % domain for domain in SUPPORTED_DOMAINS]

STATIC_URL = '/static/'

TVM_DESTINATIONS = ['TVM_BLACKBOX', 'TVM_BLACKBOX_MIMINO']

if yandex_environment_type == 'production':
    TINYURL = 'http://tinyurl.yandex.net/tiny'

    TVM_SERVICE_ID = 2017309

elif yandex_environment_type == 'testing':
    admin_host = 'admin-test.rasp.yandex.ru'

    TVM_SERVICE_ID = 2017307
    TVM_BLACKBOX = 239

elif yandex_environment_type == 'stress':
    emulator_host = 'target152g.load.yandex.net'

    # Настройки тарифов
    ASK_UFS = True
    UFS_HOST = emulator_host + ':8080'
    UFS_TRAINLIST = '/ufs/trainlist'
    UFS_CARSLISTEX = '/ufs/carslistex'
    UFS_SSL = False
    ASK_TICKETS_UA = True
    TICKETS_UA_TRAIN_URL = 'http://%s:8080/tickets_ua' % emulator_host
    UFS_PLANE_URL = "http://%s:8080/ufs" % emulator_host
    UKRMINTRANS_HOST = "http://%s:8080/ukrmintrans" % emulator_host

    TINYURL = 'http://%s/tinyurl.xml' % emulator_host

MANAGERS = ADMINS = (('Rasp Testing', 'rasp-testing@yandex-team.ru'), )
PROCESS_RCPNTS = ERROR404_RCPNTS = TABLO_ERROR_RCPNTS = ADMINS
ERRORS_RECIPIENTS = PROCESS_RCPNTS = ERROR404_RCPNTS = TABLO_ERROR_RCPNTS = ADMINS
EXPERSS_SUBST_RCPNTS = UNKNOWN_CODES_RCPNTS = RASP_FREE_STATIONS_RCPNTS = ADMINS
