# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os

from common.settings import *  # noqa
from common.settings import COMMON_CONTRIB_APPS, COMMON_INSTALLED_APPS, MDS_EXPORT_PATH


# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# On Unix systems, a value of None will cause Django to use the same
# timezone as the operating system.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'Europe/Moscow'


# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# If you set this to False, Django will not format dates, numbers and
# calendars according to the current locale.
USE_L10N = True

# If you set this to False, Django will not use timezone-aware datetimes.
USE_TZ = False

# Make this unique, and don't share it with anybody.
SECRET_KEY = 'jglkgl8976&&h09$$0c$nbre^8^55hb=7l1q57+h63dme^g*&amp;j8=)n'

DOMAIN_LANGUAGE_MAP = {
    'ru': ('ru', ['ru']),
    'tr': ('tr', ['tr']),
    'ua': ('uk', ['uk', 'ru']),
    'net': ('ru', ['ru', 'uk'])
}


def context_extractor(request):
    return {
        'user_rid': request.GET.get('_rid', ''),
        'service_rid': request.META.get('HTTP_X_REQUEST_ID', '')
    }


PYLOGCTX_REQUEST_EXTRACTOR = context_extractor

MIDDLEWARE_CLASSES = (
    'common.middleware.extract_context.ExtractRequestMiddleware',
    'common.middleware.ping.PingResponder',
    'django.middleware.common.CommonMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'common.middleware.now.Now',
    'common.middleware.host.Host',
    'common.middleware.uatraits_detector.UatraitsDetectorMiddleware',
    'common.middleware.locale_request.Locale',
    'common.geotargeting.middleware.Ip',
    'common.middleware.blackbox_session.BlackboxSessionMiddleware',
    'common.middleware.yandexuid.YandexuidMiddleware',
    'common.middleware.yauser.YaUserMiddleware',
    'common.geotargeting.middleware.GeoTargeting',
    'common.middleware.language.Language'
)

ROOT_URLCONF = 'travel.rasp.suburban_widget.suburban_widget.urls'

# Python dotted path to the WSGI application used by Django's runserver.
WSGI_APPLICATION = 'travel.rasp.suburban_widget.wsgi.application'

ALLOWED_HOSTS = ['*']

INSTALLED_APPS = COMMON_CONTRIB_APPS + COMMON_INSTALLED_APPS + [
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'route_search',
    'raven.contrib.django.raven_compat',
]

# Основные директории проекта
PROJECT_PATH = os.path.normpath(os.path.abspath(os.path.dirname(__file__)))
JINJA_TEMPLATE_DIRS = ['/app/jinja_templates']
JINJA_EXTS = ['jinja2.ext.i18n']


PRECACHE_MANAGERS = [
    'common.models.transport:TransportType.objects',
    'common.models.geo:Settlement.objects',
]


GEOTARGETING_DISABLE_REDIRECT_PREFIXES = '/'

NEAREST_SUBURBAN_STATIONS = '/var/lib/yandex-rasp-suburban-widget/export_nearest_suburban_stations.tsv'
MDS_NEAREST_SUBURBAN_STATIONS_TSV = MDS_EXPORT_PATH + 'export_nearest_suburban_stations.tsv'

LOCALE_PATHS = [
    '/app/i18n/js-locale',
    '/app/i18n/locale'
]


MDS_SYNCER_CONFIG = [
    {
        'local_path': NEAREST_SUBURBAN_STATIONS,
        'mds_key': MDS_NEAREST_SUBURBAN_STATIONS_TSV,
    }
]
