widget.onload = function() {
    var baseUrl = '/widgets/suburban/',
        $zoneSelect = $('select[name=rasp_city]'),
        $directionSelect = $('select[name=rasp_direction]'),
        $stationFrom = $('select[name=rasp_from]'),
        $stationTo = $('select[name=rasp_to]'),
        $n = $('select[name=n]'),
        $ok = $('#save-settings');

    $zoneSelect.change(function() {
        $.getJSON(baseUrl + 'directions', {
                'zone': $zoneSelect.val(),
                'locale': request_locale
            },
            function(directions) {
                var html = '<option value="" selected="selected">' + gettext('Все направления') + '</option>';

                $.each(directions, function() {
                    html += '<option value="' + this.id + '">' + this.name + '</option>';
                });

                $directionSelect.html(html);
                $directionSelect.change();
            }
        );
    });

    $directionSelect.change(function() {
        $.getJSON(baseUrl + 'stations', {
                'direction': $directionSelect.val(),
                'zone': $zoneSelect.val(),
                'locale': request_locale
            },
            function(stations) {
                var html = '<option value="" selected="selected">' + gettext('Выберите станцию') + '&hellip;</option>';

                $.each(stations, function() {
                    html += '<option value="' + this.id + '">' + this.name + '</option>';
                });

                $stationFrom.html(html);
                $stationTo.html(html);

                $stationFrom.change();
                $stationTo.change();
            }
        );
    });

    function check() {
        var stationFrom =  $stationFrom.find('option[selected]');
        var stationTo =  $stationTo.find('option[selected]');

        if(stationFrom.val() && stationTo.val() && stationFrom.val() != stationTo.val())
            $ok.show();
        else
            $ok.hide();

        $('#no_routes').hide();
    };

    $stationFrom.change(check);
    $stationTo.change(check);

    function onNChange() {
        var n = parseInt($n.val());
        
        $n.remove();

        $('#n-label').html(ngettext('Показывать <span id="n-selector" /> ближайшую электричку', 'Показывать <span id="n-selector" /> ближайших электрички', n));
        $('#n-selector').html($n);

        $n.change(onNChange);
    };

    $n.change(onNChange);

    $ok.click(function () {
        $.getJSON(baseUrl + 'next_trains', {
            'rasp_from': $stationFrom.val(),
            'rasp_to': $stationTo.val(),
            'trough_service_exists': 1,
            'locale': request_locale
        }, function(exists) {
            if(exists) {
                widget.savePreferences({
                    rasp_city: $zoneSelect.val(),
                    rasp_direction: $directionSelect.val(),
                    rasp_from: $stationFrom.val(),
                    rasp_to: $stationTo.val(),
                    n: $n.val()
                });

                widget.hidePreferences();
            } else {
                $('#no_routes').show();
            }
        });

    });

      $('#clear-settings').click(function() {
          widget.dropPreferences(function() {
              widget.hidePreferences();
          });
      });
};
