import os

from django.conf import settings


wizard_routes_cache = None
wizard_routes_timestamp = None


def get_wizard_routes():
    global wizard_routes_cache, wizard_routes_timestamp

    try:
        mtime = os.stat(settings.NEAREST_SUBURBAN_STATIONS).st_mtime
    except OSError:
        return {}

    if mtime == wizard_routes_timestamp:
        return wizard_routes_cache

    f = open(settings.NEAREST_SUBURBAN_STATIONS, 'r')

    routes = {}

    for line in f:
        geoid, station_from, _, station_to, _ = line.split('\t')[:5]

        routes[int(geoid)] = int(station_from), int(station_to)

    wizard_routes_cache = routes
    wizard_routes_timestamp = mtime

    f.close()

    return wizard_routes_cache


def search_direction(request):
    routes = get_wizard_routes()

    station_from, station_to = routes[request.geoid]

    return station_from, station_to
