package containers

import (
	"a.yandex-team.ru/travel/rasp/suggests/models"
)

// Контейнер для объектов TitleData: (id, is_prefix), хранящий только уникальные по id объекты,
// с учетом того, что из двух объектов (123, True) и (123, False) должен остаться первый.
// Порядок объектов не сохраняется.

type UniqualizerItem struct {
	position int
	isPrefix bool
}

type Uniqualizer struct {
	Items        models.TitleDataArray
	isPrefixByID map[int]UniqualizerItem
}

func (uniqualizer *Uniqualizer) AddItem(item models.TitleData) {
	value, ok := uniqualizer.isPrefixByID[item.ID]
	if !ok {
		uniqualizer.Items = append(uniqualizer.Items, item)
		uniqualizer.isPrefixByID[item.ID] = UniqualizerItem{len(uniqualizer.Items) - 1, item.IsPrefix}
	} else if !value.isPrefix && item.IsPrefix {
		uniqualizer.Items[value.position] = item
		uniqualizer.isPrefixByID[item.ID] = UniqualizerItem{value.position, true}
	}
}

func (uniqualizer *Uniqualizer) Add(items models.TitleDataArray) {
	if cap(uniqualizer.Items) == 0 && len(items) > 0 {
		uniqualizer.Items = make(models.TitleDataArray, 0, len(items))
	}
	for _, item := range items {
		uniqualizer.AddItem(item)
	}
}

func (uniqualizer *Uniqualizer) Len() int {
	return len(uniqualizer.Items)
}

// Инициализация "уникализатора".
func (uniqualizer *Uniqualizer) init() {
	uniqualizer.isPrefixByID = make(map[int]UniqualizerItem)
	uniqualizer.Items = make(models.TitleDataArray, 0)
}

// Создание "уникализатора" и его инициализация.
func NewUniqualizer() Uniqualizer {
	u := Uniqualizer{}
	u.init()
	return u
}
