package logger

import (
	"fmt"
	simple_log "log"
	"sync"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
)

var singleton *zap.Logger
var once sync.Once

func Init() {
	once.Do(func() {
		var err error
		singleton, err = zap.NewDeployLogger(log.InfoLevel)
		if err != nil {
			simple_log.Fatal(err.Error())
		}
	})
}

func Debug(message string, fields ...log.Field) {
	singleton.Debug(message, fields...)
}

func Debugf(message string, params ...interface{}) {
	singleton.Debug(fmt.Sprintf(message, params...))
}

func Info(message string, fields ...log.Field) {
	singleton.Info(message, fields...)
}

func Infof(message string, params ...interface{}) {
	singleton.Info(fmt.Sprintf(message, params...))
}

func Warn(message string, fields ...log.Field) {
	singleton.Warn(message, fields...)
}

func Error(message string, fields ...log.Field) {
	singleton.Error(message, fields...)
}

func Errorf(message string, params ...interface{}) {
	singleton.Error(fmt.Sprintf(message, params...))
}

func Fatal(message string, fields ...log.Field) {
	singleton.Fatal(message, fields...)
}

func Panic(message string, fields ...log.Field) {
	singleton.Fatal(message, fields...)
}

func With(fields ...log.Field) log.Logger {
	return singleton.With(fields...)
}
