package search

import (
	"sync"

	"a.yandex-team.ru/travel/rasp/suggests/logger"
	"a.yandex-team.ru/travel/rasp/suggests/models"
)

type cacheValue struct {
	data []models.MainSearchResult
	done chan interface{}
}

type cacheKey struct {
	fromType        string
	fromID          int
	region          int
	ttype           string
	lang            string
	nationalVersion string
	suggestType     string
}

type EmptySearchCache struct {
	cacheData sync.Map
}

func NewEmptySearchCache() EmptySearchCache {
	return EmptySearchCache{sync.Map{}}
}

func (sc *EmptySearchCache) GetValue(limit, region int, from *models.DBLocationInfo, ttypes []string, lang, nationalVersion, suggestType string) ([]models.MainSearchResult, bool) {
	fromID, fromType := from.RawView()
	key := cacheKey{fromType, fromID, region, ttypes[0], lang, nationalVersion, suggestType}
	m := &sync.Mutex{}
	m.Lock()
	if data, ok := sc.cacheData.Load(key); ok {
		dataValue := data.(cacheValue)
		m.Unlock()
		<-dataValue.done

		result, _ := sc.cacheData.Load(key)
		return result.(cacheValue).data[:limit], true
	} else {
		defer m.Unlock()
	}
	sc.cacheData.Store(key, cacheValue{
		done: make(chan interface{}, 1),
	})
	return []models.MainSearchResult{}, false
}

func (sc *EmptySearchCache) SetValue(result []models.MainSearchResult, region int, from *models.DBLocationInfo, ttypes []string, lang, nationalVersion, suggestType string) {
	fromID, fromType := from.RawView()
	key := cacheKey{fromType, fromID, region, ttypes[0], lang, nationalVersion, suggestType}
	item, ok := sc.cacheData.Load(key)
	if !ok {
		logger.Info("Can't set cache value")
		return
	}
	ch := item.(cacheValue).done
	sc.cacheData.Store(key, cacheValue{result, ch})
	close(ch)
}
