package search

import (
	"a.yandex-team.ru/travel/rasp/suggests/models"
)

type suggestFilter func(models.FullObjectData) bool

func filterSettlementSuggests(item models.FullObjectData) bool {
	return item.IsSettlement()
}

func filterStationSuggests(item models.FullObjectData) bool {
	return item.IsStation()
}

func filterByFilterDataFactory(filterData *models.FilterData) func(item models.FullObjectData) bool {
	return func(item models.FullObjectData) bool {
		_, exists := ((*filterData).PointKeys)[item.PointKey]
		return exists
	}
}

func nestedFactory(filter1 suggestFilter, filter2 suggestFilter) func(item models.FullObjectData) bool {
	return func(item models.FullObjectData) bool {
		return (filter1 == nil || filter1(item)) && (filter2 == nil || filter2(item))
	}
}
