package search

import (
	"sync"

	"a.yandex-team.ru/travel/rasp/suggests/models"
)

type SearchEngine struct {
	finder                *ChannelFinder
	wordPreparer          *RequestPreparer
	name                  string
	RunOnlyIfNothingFound bool
}

func NewSearchEngine(finder ChannelFinder, wordPreparer RequestPreparer, name string, RunOnlyIfNothingFound bool) SearchEngine {
	return SearchEngine{&finder, &wordPreparer, name, RunOnlyIfNothingFound}
}

func (se SearchEngine) FindToChan(text string, limit int, ch chan models.TitleData, wg *sync.WaitGroup, hasData bool) {
	if wg != nil {
		defer wg.Done()
	}

	if se.RunOnlyIfNothingFound && hasData {
		return
	}

	preparedRequests := (*se.wordPreparer).GetTexts(text)

	for _, preparedRequest := range preparedRequests {
		(*se.finder).FindToChan(preparedRequest, limit, ch, nil, hasData)
	}
}
