package _debug

import (
    "time"

    "a.yandex-team.ru/library/go/core/log"
)

// Usage:
// defer TimeTrack(time.Now(), "Function Name", nil)
func TimeTrack(start time.Time, name string, logger log.Logger) {
    if logger == nil {
        logger = log.With(log.String("func", name))
    }
    logger.Debugf("Function %s took %s.", name, time.Since(start))
}
