package utils

import (
	"fmt"
	"io/ioutil"
	"net/http"
	"net/url"
	"path"
	"strconv"

	"a.yandex-team.ru/travel/rasp/suggests/models"
)

var apiURL = "http://geobase.qloud.yandex.ru/v1/"

func sendRequest(method string, params map[string]string) ([]byte, error) {
	reqURL, err := url.Parse(apiURL)
	if err != nil {
		return []byte{}, fmt.Errorf("utils.geobase:sendRequest. Parsing geobase api url failed: %w", err)
	}

	reqURL.Path = path.Join(reqURL.Path, method)
	q := reqURL.Query()
	for param, val := range params {
		q.Add(param, val)
	}
	reqURL.RawQuery = q.Encode()

	req, err := http.Get(reqURL.String())
	if err != nil {
		return []byte{}, fmt.Errorf("utils.geobase:sendRequest. Sending geobase request failed: %w", err)
	}
	defer req.Body.Close()
	data, err := ioutil.ReadAll(req.Body)
	if err != nil {
		return []byte{}, fmt.Errorf("utils.geobase:sendRequest. Reading geobase response failed: %w", err)
	}
	return data, nil
}

func GetParents(id int) ([]int, error) {
	data, err := sendRequest("parents", map[string]string{"id": strconv.Itoa(id)})
	if err != nil {
		return []int{}, fmt.Errorf("utils.geobase:GetParents. Getting parents failed.: %w", err)
	}
	var res models.IntSlice
	if err := res.UnmarshalJSON(data); err != nil {
		return []int{}, fmt.Errorf("utils.geobase:GetParents. Getting parents failed, city id is %d.: %w", id, err)
	}
	return res, nil
}
