package utils

import (
	"a.yandex-team.ru/travel/rasp/suggests/models"
)

type IDConverter interface {
	LocalIDToDB(int) models.DBLocationInfo
	DatabaseIDToLocal(models.DBLocationInfo) int
}

type BaseIDConverter struct {
	Data *models.IDConvertingData
}

func (idConverter BaseIDConverter) LocalIDToDB(id int) models.DBLocationInfo {
	return idConverter.Data.LocalToDB[id]
}

func (idConverter BaseIDConverter) DatabaseIDToLocal(loc models.DBLocationInfo) int {
	switch loc.Type {
	case "station":
		return idConverter.Data.DBToLocal.Station[loc.ID]
	case "settlement":
		return idConverter.Data.DBToLocal.Settlement[loc.ID]
	default:
		return -1
	}
}
