package utils

import (
	"bytes"
	"fmt"
	"io/ioutil"

	"github.com/vmihailenco/msgpack"

	"a.yandex-team.ru/travel/rasp/suggests/models"
)

func ReadObjectData(filename string) (models.ObjectData, error) {
	var result models.ObjectData
	fileContents, err := ioutil.ReadFile(filename)
	if err != nil {
		return models.ObjectData{}, fmt.Errorf("reading object data failed: %w ", err)
	}
	decoder := msgpack.NewDecoder(bytes.NewReader(fileContents)).UseJSONTag(true)
	err = decoder.Decode(&result)
	if err != nil {
		return models.ObjectData{}, fmt.Errorf("reading object data failed: %w ", err)
	}
	return result, nil
}

func ReadIDConverter(filename string) (models.IDConvertingData, error) {
	var result models.IDConvertingData
	fileContents, err := ioutil.ReadFile(filename)
	if err != nil {
		return models.IDConvertingData{}, fmt.Errorf("reading ID converter data failed: %w ", err)
	}
	decoder := msgpack.NewDecoder(bytes.NewReader(fileContents)).UseJSONTag(true)
	err = decoder.Decode(&result)
	if err != nil {
		return models.IDConvertingData{}, fmt.Errorf("reading ID converter data failed: %w ", err)
	}
	return result, nil
}

func ReadFilterData(filename string) (models.FilterData, error) {
	var result models.FilterData
	fileContents, err := ioutil.ReadFile(filename)
	if err != nil {
		return models.FilterData{}, fmt.Errorf("pointKey filter data failed %w", err)
	}
	decoder := msgpack.NewDecoder(bytes.NewReader(fileContents)).UseJSONTag(true)
	err = decoder.Decode(&result)
	if err != nil {
		return models.FilterData{}, fmt.Errorf("pointKey filter data failed %w", err)
	}
	return result, nil
}
