# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import os
import sys

from travel.library.python.entrypoint import *  # noqa
from travel.library.python.entrypoint import scheduler_base, launch_base, default_run
from travel.library.python.entrypoint.scheduler import run_job


def _load_project():
    os.environ.setdefault("DJANGO_SETTINGS_MODULE", "local_settings")

    import django
    django.setup()

    from common.db.switcher import switcher
    switcher.sync_db()


def launch():
    _load_project()

    from travel.rasp.suggests_tasks.job_config import job_config
    launch_base(job_config)


def scheduler():
    _load_project()

    from django.conf import settings
    from travel.rasp.suggests_tasks.job_config import job_config

    if not os.path.exists(os.path.join(settings.DATA_PATH, 'stat.msgpack')):
        run_job(sys.executable, 'search_stat', env={'Y_PYTHON_ENTRY_POINT': 'travel.rasp.suggests_tasks.app:launch'}, timeout=3600 * 10)
    scheduler_base(job_config, 'travel.rasp.suggests_tasks.app:launch')


if __name__ == '__main__':
    default_run(globals())
