# coding: utf8

import os.path

from common.settings.configuration import Configuration
from travel.rasp.suggests_tasks.settings import *  # noqa
from travel.rasp.suggests_tasks.suggests.generate.settings import *  # noqa

pkg_version = os.environ['QLOUD_DOCKER_IMAGE'].rsplit(':', 1)[-1]
if pkg_version == 'latest':
    pkg_version = os.environ['QLOUD_DOCKER_HASH']

PKG_VERSION = pkg_version


Configuration().apply(globals())

BASE_LOG_LEVEL = os.environ.get('RASP_BASE_LOG_LEVEL', 'INFO')
LOG_PATH = '/var/log/app/'
LOG_FORMAT = '%(name)s %(process)d %(asctime)s %(levelname)s: %(message)s'

_format = '%(levelname)s %(asctime)s %(process)d %(name)s %(message)s'

if APPLIED_CONFIG == Configuration.PRODUCTION:  # noqa
    YT_PREFIX = 'production'
elif APPLIED_CONFIG == Configuration.TESTING:  # noqa
    YT_PREFIX = 'testing'


LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'simple': {
            'format': _format
        },
        'qloud_warnings': {
            '()': 'travel.rasp.library.python.common23.logging.qloud.QloudJsonFormatter',
            'tag': 'warnings'
        },
        'qloud_app': {
            '()': 'travel.rasp.library.python.common23.logging.qloud.QloudExceptionFormatter',
            'add_request_info': True,
            'tag': 'app'
        }
    },
    'filters': {
        'unique_warnings': {
            '()': 'travel.rasp.library.python.common23.logging.WarningFilterOnce'
        }
    },
    'handlers': {
        'app': {
            'class': 'travel.rasp.library.python.common23.logging.WatchedFileHandler',
            'filename': os.path.join(LOG_PATH, 'app.log'),
            'formatter': 'simple',
        },
        'warnings': {
            'class': 'travel.rasp.library.python.common23.logging.WatchedFileHandler',
            'filename': os.path.join(LOG_PATH, 'warnings.log'),
            'formatter': 'simple',
        },
        'stdout_app': {
            'class': 'logging.StreamHandler',
            'stream': 'ext://sys.stdout',
            'formatter': 'qloud_app'
        },
        'stdout_warnings': {
            'class': 'logging.StreamHandler',
            'stream': 'ext://sys.stdout',
            'formatter': 'qloud_warnings',
        }
    },
    'loggers': {
        '': {
            'handlers': ['app', 'stdout_app'],
            'level': BASE_LOG_LEVEL,
        },
        'py.warnings': {
            'filters': ['unique_warnings'],
            'propagate': False,
            'handlers': ['warnings', 'stdout_warnings'],
            'level': BASE_LOG_LEVEL,
        }
    }
}
