# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from common.settings.utils import define_setting
from django.conf import settings

from travel.rasp.suggests_tasks.suggests.generate import generate
from travel.rasp.suggests_tasks.suggests.generate.ytwork import search_stat


define_setting('SEARCH_STAT_CRON', default='30 3 * * *')
define_setting('GENERATE_CRON', default='0 */3 * * *')

job_config = [
    [
        'search_stat', search_stat.run,
        {
            'schedule': {
                'cron': settings.SEARCH_STAT_CRON,
                'timeout': 3600 * 10
            },
            'args': [
                settings.DATA_PATH,
                settings.YT_PREFIX,
                90
            ]
        }
    ],
    [
        'generate', generate.run,
        {
            'schedule': {
                'cron': settings.GENERATE_CRON,
                'timeout': 3600 * 10
            },
            'args': [
                settings.DATA_PATH
            ]
        }
    ]
]
