# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.models.geo import Country


def countries(*titles):
    return list(Country.objects.filter(title__in=titles))


OUR_COUNTRIES = countries(u'Россия', u'Украина', u'Беларусь', u'Казахстан', u'Турция')
USSR_COUNTRIES = countries(
    u'Азербайджан',
    u'Армения',
    u'Грузия',
    u'Киргизия',
    u'Латвия',
    u'Литва',
    u'Молдавия',
    u'Таджикистан',
    u'Туркмения',
    u'Узбекистан',
    u'Эстония',
)

EUROPE_COUNTRIES = countries(
    u'Германия',
    u'Великобритания',
    u'Австрия',
    u'Бельгия',
    u'Болгария',
    u'Венгрия',
    u'Нидерланды',
    u'Норвегия',
    u'Польша',
    u'Словакия',
    u'Словения',
    u'Финляндия',
    u'Франция',
    u'Чехия',
    u'Швейцария',
    u'Швеция',
    u'Сербия',
    u'Дания',
    u'Испания',
    u'Италия',
    u'Греция',
    u'Литва',
    u'Эстония',
    u'Латвия',
    u'Турция',
    u'Албания',
    u'Босния и Герцеговина',
    u'Ирландия',
    u'Исландия',
    u'Лихтенштейн',
    u'Македония',
    u'Мальта',
    u'Монако',
    u'Португалия',
    u'Румыния',
    u'Хорватия',
    u'Андорра',
    u'Гибралтар',
    u'Кипр',
    u'Сан-Марино',
    u'Люксембург',
    u'Ватикан',
    u'Черногория',
)

OTHER_COMMON_COUNTRIES = countries(u'США', u'Канада', u'Китай', u'Япония')

ALL_IMPORTANT_COUNTRIES = OUR_COUNTRIES + USSR_COUNTRIES + EUROPE_COUNTRIES + OTHER_COMMON_COUNTRIES

# https://st.yandex-team.ru/RASPSUGGESTS-20
COUNTRY_GROUPS = [
    OTHER_COMMON_COUNTRIES,
    EUROPE_COUNTRIES,
    USSR_COUNTRIES,
    OUR_COUNTRIES,
]

COUNTRY_MAJORITY = {
    country.title: maj
    for maj, countries in enumerate(COUNTRY_GROUPS, start=2)
    for country in countries
}
