# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from common.settings import *  # noqa

INSTALLED_APPS = [
    'django.contrib.contenttypes',
    'django.contrib.auth',
    'django.contrib.sites',
    'raven.contrib.django.raven_compat',
] + COMMON_INSTALLED_APPS  # noqa


def with_suffix(suffix, prefixes):
    return [prefix + suffix for prefix in prefixes]


PRECACHE = with_suffix('.objects.precache', [
    'common.models.geo:StationType',
    'common.models.geo:StationMajority',
    'common.models.transport:TransportType',
    'common.models.transport:TransportModel',
    'common.models.geo:CodeSystem',
    'common.models.geo:Country',
    'common.models.geo:Region',
    'common.models.geo:Settlement',
    'common.models.geo:District',
    'common.models.geo:SuburbanZone',
])

# Yt stuff
YT_CLUSTER = 'hahn'


YT_SEARCH_LOG_PATH = '//home/rasp/logs/rasp-users-search-log'
YT_ROOT_PATH = '//home/rasp/rasp/suggests'
YT_PREFIX = 'dev'


DATA_PATH = '/ephemeral/app-data'
# порядок важен, т.к. гуникорн следит за изменением objs_data.msgpack # TODO: fix
DATA_FILES = ['idconverter.msgpack', 'objs_data.msgpack']

RSYNC_CONFIG = []

LOGLEVEL = logging.WARNING

THREAD_DENSITY_DAYS = 92  # используем плотность ниток настолько дней вперед

SETT_GEO_WEIGHTS = {
    'base': 10,
    'country': 25,
    'region': 35,
    'settlement': 35
}

STATION_NORM_COEF = (0.1, 0.95)

MDS_CONFIG = {
    'prefix': 'suggests',
    'files': ['idconverter.msgpack', 'objs_data.msgpack']
}


class BOOST(object):
    OUR_COUNTRY_CAPITAL = 100
    IMPORTANT_COUNTRY_CAPITAL = 5
    LARGE_CITIES = 10  # только для регионов и стран
