# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function
"""
Склад объектов, которые используются разными процессами при форках в multiprocessing.
Это единое место нужно, чтобы скрипты не уходили в кольцевой импорт при
попытках использовать данные друг из друга.
Да и просто чтоб не передавать слишком много параметров в подпроцессы.
"""

_objs = {
    'id_converter': None,
    'threads': None,
    'sett_one_station': None,
    'station_codes': None,
    'settlement_codes': None,
    'synonyms': None,
    'stat_weights': None,
    'threads_ttypes': None,
    'stations_ttypes': None,
    'settlements_ttypes': None,
}


def get_obj(name):
    assert name in _objs
    return _objs[name]


def set_objs(**kwargs):
    for name, obj in kwargs.items():
        assert name in _objs
        _objs[name] = obj


def clear_objs():
    kwargs = {key: None for key in _objs.keys()}
    set_objs(**kwargs)
