# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import msgpack


def iterable_to_dict(l, keys):
    if len(l) != len(keys):
        raise ValueError('Wrong length.')
    return dict(zip(keys, l))


def _remove_none(data):
    for key in data['objects_data']:
        if data['objects_data'][key]['zone_id'] is None:
            data['objects_data'][key]['zone_id'] = -1
        for code in data['objects_data'][key]['codes']:
            if data['objects_data'][key]['codes'][code] is None:
                data['objects_data'][key]['codes'][code] = ''
        for weight, weight_val in data['objects_data'][key]['weights'].items():
            for wid, wval in weight_val.items():
                if wid is None:
                    weight_val[-1] = wval
                    weight_val.pop(None)
    for key in data['stat_routes']:
        for fid in data['stat_routes'][key]:
            for tid, tval in data['stat_routes'][key][fid].items():
                for rkey, rval in tval.items():
                    if rkey is None:
                        tval[-1] = rval
                        tval.pop(None)


def reformat_idconverter(data):
    for key, value in data['local_to_db'].items():
        data['local_to_db'][key] = iterable_to_dict(value, ('type', 'id'))
    return data


def reformat_objs_data(data, remove_none=True):
    if remove_none:
        _remove_none(data)
    keys = ('id', 'is_prefix')
    for lang, lang_val in data['titles'].items():
        for ttype, ttype_val in lang_val.items():
            for req, req_val in ttype_val.items():
                result = [iterable_to_dict(item, keys) for item in req_val]
                data['titles'][lang][ttype][req] = result
    return data


def reformat_msgpack(raw_data, reformat_func):
    data = msgpack.loads(raw_data)
    return msgpack.dumps(reformat_func(data))
