# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function


def get_obj_type(obj):
    from common.models.geo import Station, Settlement, Country

    return {
        Station: 'station',
        Settlement: 'settlement',
        Country: 'country',
    }[obj.__class__]


class ObjIdConverter(object):
    """
    Конвертим пару (модель объекта + id объекта в базе) в новый генеренный id,
    чтобы иметь сквозные int-овые идентификаторы независимо от модели.
    """

    def __init__(self, db_id_to_local_id=None, local_id_to_db_id=None, freeze=False):
        self.db_id_to_local_id = db_id_to_local_id or {}
        self.local_id_to_db_id = local_id_to_db_id or {}
        self.freeze = freeze

        self.current_local_id = 0

    def get_local_id(self, db_id, obj_type):
        if isinstance(db_id, basestring):
            db_id = int(db_id)

        by_type = self.db_id_to_local_id.setdefault(obj_type, {})
        local_id = by_type.get(db_id)
        if local_id is not None:
            return local_id

        if self.freeze:
            return None

        self.current_local_id += 1
        local_id = self.current_local_id
        by_type[db_id] = local_id
        self.local_id_to_db_id[local_id] = (obj_type, db_id)

        return local_id

    def get_type_and_db_id(self, local_id):
        return self.local_id_to_db_id[local_id]

    def to_dict(self):
        return {
            'local_to_db': self.local_id_to_db_id,
            'db_to_local': self.db_id_to_local_id,
        }

    @classmethod
    def from_dict(cls, dct, freeze):
        id_converter = cls(freeze=freeze)
        id_converter.db_id_to_local_id = dct['db_to_local']
        id_converter.local_id_to_db_id = dct['local_to_db']

        if id_converter.local_id_to_db_id:
            id_converter.current_local_id = max(id_converter.local_id_to_db_id.keys())
        else:
            id_converter.current_local_id = 0

        return id_converter
