# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import re
from collections import defaultdict
from string import whitespace, punctuation

from travel.rasp.library.python.common23.utils.text import PUNTO_DIRECTIONS, _punto_maps, transliterate


def keyboard_layout_variants(text, langs=None):
    if langs is None:
        langs = ['ru']
    text = text.lower()

    result = defaultdict(list)
    seen = {text}
    punto_directions = [i for i, direction in enumerate(PUNTO_DIRECTIONS)
                        for lang in langs if direction[1] == lang]

    for dir_id in punto_directions:
        char_map = _punto_maps[dir_id]
        mapped = char_map(text)
        if mapped not in seen:
            result[PUNTO_DIRECTIONS[dir_id][1]].append(mapped)
            seen.add(mapped)
    return result


def transliteration_variant(text, lang):
    if lang == 'ru':
        return transliterate(text, 'lat-cyr')
    if lang == 'en':
        return transliterate(text, 'cyr-lat')


def create_separators():
    separators = list(whitespace) + list(punctuation)

    nbsp = u' '
    separators.extend([u'«', u'»', nbsp])
    return separators


SEPARATORS = create_separators()
re_separators = re.compile(u'[{}]+'.format(u'\\'.join(SEPARATORS)))


def prepare_title_text(title):
    title = title.lower()
    text = re.sub(re_separators, u' ', title).strip()
    return text


TITLE_LANGS = ['ru', 'en', 'uk']
TITLE_NATIONAL_VERSIONS = ['ru', 'ua']
LANGS_ORDER_BY_NATIONAL_VERSION = {'ru': ['ru', 'en', 'uk'],
                                   'ua': ['uk', 'ru', 'en']}
