# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import os

from travel.rasp.tasks.min_prices import direct_feeds
from travel.rasp.tasks.min_prices import min_prices_yt_cleaner
from travel.rasp.tasks.min_prices import pack_avia_prices
from travel.rasp.tasks.min_prices import pack_min_avia_prices
from travel.rasp.tasks.min_prices import yt_to_mongo

os.environ['YT_LOG_LEVEL'] = 'WARNING'


def run():
    pack_avia_prices.run(from_day=0, to_day=2)
    pack_min_avia_prices.run(from_day=0, to_day=4)
    yt_to_mongo.run('rasp-min-prices-by-routes', days_ago=1, remove_old_prices_days=3)
    yt_to_mongo.run('rasp-min-prices-by-routes', days_ago=0, remove_old_prices_days=3)
    direct_feeds.run(log_search_depth=14, trip_days_count=14)
    min_prices_yt_cleaner.run(days_ago=30, remove_old_tables_days=7)
