# coding: utf-8

import argparse
import logging  # noqa
import os

from django.conf import settings

from common.utils.currency_converter import AVIA_CURRENCY, fetch_currency_rates
from common.utils.lock import lock
from travel.rasp.library.python.common23.logging.scripts import script_context
from travel.rasp.tasks.min_prices.yt_min_avia_price import YtMinAviaPrice


log = logging.getLogger('pack_avia_price')


def run(from_day, to_day):
    with lock('pack_avia_prices'), script_context('pack_avia_prices'):
        log.info('arguments: %s, %s', from_day, to_day)

        src, rates = fetch_currency_rates(AVIA_CURRENCY)

        try:
            for i in range(from_day, to_day):
                runner = YtMinAviaPrice(rates,
                                        i, i + 1,
                                        os.path.join(settings.YT_LOG_PATH, 'rasp-tariffs-log'),
                                        os.path.join(settings.YT_ROOT_PATH,
                                                     settings.YANDEX_ENVIRONMENT_TYPE,
                                                     'rasp-min-prices-by-routes'),
                                        settings.YT_ROOT_PATH,
                                        settings.YT_TOKEN, settings.YT_PROXY)
                runner.start()
        except Exception:
            log.exception('pack_avia_price exception:')


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('-f', '--from_day', dest='from_day', type=int, default=0,
                        help=u'0 - с сегодня, 1 - со вчера')
    parser.add_argument('-t', '--to_day', dest='to_day', type=int, default=1, help=u'1 - до сегодня, 2 - до вчера')
    args = parser.parse_args()
