# coding: utf-8

import argparse
import logging  # noqa
import os

from django.conf import settings

from common.utils.lock import lock
from travel.rasp.library.python.common23.logging.scripts import script_context
from travel.rasp.tasks.min_prices.yt_min_avia_price import YtMinAviaPrice


def run(from_day, to_day):
    with lock('pack_min_avia_prices'), script_context('pack_min_avia_prices'):
        # по какой-то причине, возможно из-за CleanRunner, __name__ не работает
        log = logging.getLogger('pack_min_avia_price')
        log.info('arguments: %s, %s', from_day, to_day)

        try:
            runner = YtMinAviaPrice({},
                                    from_day, to_day,
                                    os.path.join(settings.YT_ROOT_PATH, settings.YANDEX_ENVIRONMENT_TYPE,
                                                 'rasp-min-prices-by-routes'),
                                    os.path.join(settings.YT_ROOT_PATH, settings.YANDEX_ENVIRONMENT_TYPE,
                                                 'rasp-min-prices-some-days'),
                                    settings.YT_ROOT_PATH,
                                    settings.YT_TOKEN, settings.YT_PROXY)
            runner.start()
        except Exception:
            log.exception('pack_min_avia_price exception:')


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('-f', '--from_day', dest='from_day', type=int, default=0,
                        help=u'0 - с сегодня, 1 - со вчера')
    parser.add_argument('-t', '--to_day', dest='to_day', type=int, default=3, help=u'1 - до сегодня, 2 - до вчера')
    args = parser.parse_args()
    run(args.from_day, args.to_day)
