# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import travel.rasp.tasks.monitoring.load_rasp_project  # noqa

from datetime import timedelta  # noqa: I

from common.apps.suburban_events.models import ThreadStationState, LVGD01_TR2PROC_query
from travel.rasp.library.python.common23.date.environment import now_utc, now
from travel.rasp.library.python.common23.data_api.juggler.juggler import CheckError, CRIT, get_events, send_events

TSS_UPDATE_DELAY = timedelta(minutes=20)
VALID_RZD_QUERIES_DELAY = timedelta(minutes=15)


def has_recent_station_states():
    """ Проверяем, что есть недавно появившиеся состояния станций ниток. """
    last_tss = ThreadStationState.objects.order_by('-id').first()

    if not last_tss or last_tss.id.generation_time + TSS_UPDATE_DELAY < now_utc(aware=True):
        msg = "No recent thread stations states. "
        if not last_tss:
            msg += "No tss in db at all"
        else:
            msg += "Last tss generation time: {}".format(last_tss.id.generation_time)

        raise CheckError(CRIT, msg)


def has_recent_valid_queries():
    """ Проверяем, что есть недавние удачно завершенные запросы к РЖД. """
    valid_queries_count = LVGD01_TR2PROC_query.objects.filter(
        queried_at__gte=now() - VALID_RZD_QUERIES_DELAY,
        exception=None,
        new_rows_count__gt=0,
    ).count()

    if not valid_queries_count:
        raise CheckError(CRIT, 'No recent valid rzd queries')


def run():
    tags = ['rzd', 'suburban_events']
    checks_events = get_events([
        ('suburban-events-rzd-queries', has_recent_valid_queries, tags),
        ('suburban-events-recent-station-states', has_recent_station_states, tags)
    ])

    for event in checks_events:
        event.host = 'RaspSuburbanEvents'

    send_events(checks_events)


if __name__ == '__main__':
    run()
