# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging  # noqa
from datetime import timedelta

from django.conf import settings
from pymongo.errors import OperationFailure

from common.data_api.platforms.client import get_dynamic_platform_collection
from common.settings.utils import define_setting
from travel.rasp.library.python.common23.date.environment import now_aware
from common.utils.lock import lock
from travel.rasp.library.python.common23.logging import log_run_time
from travel.rasp.library.python.common23.logging.scripts import script_context

log = logging.getLogger(__name__)


define_setting('DYNAMIC_PLATFORMS_TIMESPAN_DAYS', default=5)


def remove_old_rows(days_ago):
    coll = get_dynamic_platform_collection()
    delete_result = coll.delete_many({'date': {'$lt': (now_aware() - timedelta(days=days_ago)).date().isoformat()}})
    log.info('Removed %s rows', delete_result.deleted_count)


def run():
    try:
        with log_run_time('clean_dynamic_platforms', logger=log):
            remove_old_rows(settings.DYNAMIC_PLATFORMS_TIMESPAN_DAYS)
    except OperationFailure as ex:
        log.exception('clean_dynamic_platforms failed {};{}'.format(ex.code, ex.details))
        raise
    except Exception:
        log.exception('clean_dynamic_platforms failed')
        raise


def lock_aware_run():
    with lock('lock_update_dynamic_platforms', database_name=settings.DYNAMIC_PLATFORMS_DB_ALIAS), \
            script_context('clean_dynamic_platforms'):

        run()


if __name__ == '__main__':
    lock_aware_run()
