# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.settings import *  # noqa
from common.settings.configuration import BaseConfigurator, Configuration

INSTALLED_APPS = COMMON_CONTRIB_APPS + COMMON_INSTALLED_APPS + ['route_search']  # noqa

YT_PROXY = 'hahn.yt.yandex.net'

YT_ROOT_PATH = '//home/rasp/rasp/min_price'
YT_SEARCH_LOG_PATH = '//home/rasp/logs/rasp-users-search-log'
YT_LOG_PATH = '//home/rasp/logs'


PRECACHE_MANAGERS = [
    'common.models.geo:Station.code_manager'
]

BASE_LOG_LEVEL = os.environ.get('RASP_BASE_LOG_LEVEL', 'INFO')  # noqa
LOG_PATH = '/var/log/app/'
LOG_FORMAT = '%(name)s %(process)d %(asctime)s %(levelname)s: %(message)s'


class TasksConfigurator(BaseConfigurator):
    def apply_base(self, settings):
        self.setup_logging(settings)

        settings['MONGO_DATABASES']['default'].setdefault('options', {}).update({
            'socketTimeoutMS': None,
            'connectTimeoutMS': 20000,
            'serverSelectionTimeoutMS': 30000
        })

        suburban_db = settings['MONGO_DATABASES'][settings['SUBURBAN_EVENTS_DATABASE_NAME']]
        suburban_db.setdefault('options', {})['socketTimeoutMS'] = 2 * 60 * 1000

    def setup_logging(self, settings):
        settings['LOGGING'] = {
            'version': 1,
            'disable_existing_loggers': False,
            'formatters': {
                'qloud_json': {
                    '()': 'travel.rasp.library.python.common23.logging.qloud.QloudExceptionFormatter',
                    'add_request_info': True,
                },
                'line': {
                    '()': 'ylog.ExceptionFormatter',
                    'format': '%(asctime)s %(process)d %(levelname)s %(name)s %(message)s %(context)s',
                    'full': True
                }
            },
            'filters': {
                'unique_warnings': {
                    '()': 'travel.rasp.library.python.common23.logging.WarningFilterOnce'
                },
                'context_filter': {
                    '()': 'travel.rasp.library.python.common23.logging.AddContextFilter'
                },
                'context_as_dict_filter': {
                    '()': 'travel.rasp.library.python.common23.logging.AddContextFilter',
                    'as_dict': True
                }
            },
            'handlers': {
                'application.log': {
                    'class': 'travel.rasp.library.python.common23.logging.WatchedFileHandler',
                    'filters': ['context_filter'],
                    'filename': os.path.join(settings['LOG_PATH'], 'application.log'),  # noqa
                    'formatter': 'line'
                },
                'qloud_stdout': {
                    'class': 'logging.StreamHandler',
                    'filters': ['context_as_dict_filter'],
                    'formatter': 'qloud_json',
                    'stream': 'ext://sys.stdout',
                },
            },
            'loggers': {
                '': {
                    'handlers': ['application.log', 'qloud_stdout'],
                    'level': BASE_LOG_LEVEL,
                },
                'py.warnings': {
                    'handlers': ['application.log', 'qloud_stdout'],
                    'filters': ['unique_warnings'],
                    'propagate': False,
                    'level': BASE_LOG_LEVEL,
                }
            }
        }


Configuration.configurator_classes += [TasksConfigurator]
