# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging  # noqa

from django.conf import settings

from common.apps.suburban_events.scripts import clean
from common.utils.lock import lock
from travel.rasp.library.python.common23.logging.scripts import script_context

log = logging.getLogger('clean_suburban_events')


def run():
    try:
        clean.clean()
    except Exception:
        log.exception('clean failed')
        raise


def lock_aware_run():
    with lock('lock_clean_suburban_events', 'suburban_events_process',
              database_name=settings.SUBURBAN_EVENTS_DATABASE_NAME), script_context('clean_suburban_events'):
        run()


if __name__ == '__main__':
    lock_aware_run()
