# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging  # noqa

from django.conf import settings
from pymongo.errors import OperationFailure

from common.apps.suburban_events.scripts.update_companies_crashes import update_companies_events_rate
from common.precache.backend import precache
from common.utils.lock import lock
from travel.rasp.library.python.common23.logging import log_run_time
from travel.rasp.library.python.common23.logging.scripts import script_context

log = logging.getLogger('update_company_crashes')


def run():
    precache()

    try:
        with log_run_time('update_company_crashes', logger=log):
            update_companies_events_rate()
    except OperationFailure as ex:
        log.exception('update_company_crashes failed {};{}'.format(ex.code, ex.details))
        raise
    except Exception:
        log.exception('update_company_crashes failed')
        raise


def lock_aware_run():
    with lock('lock_update_company_crashes', 'suburban_events_process', timeout=1200, database_name=settings.SUBURBAN_EVENTS_DATABASE_NAME), script_context('update_company_crashes'):
        run()


if __name__ == '__main__':
    lock_aware_run()
