# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging  # noqa
from datetime import timedelta

from django.conf import settings
from pymongo.errors import OperationFailure

from common.apps.suburban_events.scripts.precalc_thread_events import precalc_all_expected_thread_events
from travel.rasp.library.python.common23.date.environment import now
from common.utils.lock import lock
from travel.rasp.library.python.common23.logging import log_run_time
from travel.rasp.library.python.common23.logging.scripts import script_context

log = logging.getLogger('update_expected_suburban_events')


def run():
    try:
        with log_run_time('update_expected_suburban_events', logger=log):
            start_date = now() + timedelta(days=1)
            precalc_all_expected_thread_events(start_date=start_date)
    except OperationFailure as ex:
        log.exception(u'update_expected_suburban_events failed {};{}'.format(ex.code, ex.details))
        raise
    except Exception:
        log.exception(u'update_expected_suburban_events failed')
        raise


def lock_aware_run():
    with lock('lock_update_expected_suburban_events', 'suburban_events_process', timeout=1200,
              database_name=settings.SUBURBAN_EVENTS_DATABASE_NAME),\
            script_context('update_expected_suburban_events'):
        run()


if __name__ == '__main__':
    lock_aware_run()
