# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging  # noqa
from datetime import datetime

from django.conf import settings
from pymongo.errors import OperationFailure

from common.apps.suburban_events import dynamic_params
from common.apps.suburban_events.scripts.precalc_thread_events import precalc_all_expected_thread_events
from common.db import maintenance
from common.models.timestamp import Timestamp
from travel.rasp.library.python.common23.date.environment import now
from common.utils.lock import lock
from travel.rasp.library.python.common23.logging import log_run_time
from travel.rasp.library.python.common23.logging.scripts import script_context


log = logging.getLogger('update_expected_suburban_events_after_prepare_all')


def run():
    try:
        last_prepare_all_time = Timestamp.get('prepare_all')
        last_switch_time_str = maintenance.read_conf()['last_successful_switch']
        last_switch_time = datetime.strptime(last_switch_time_str, '%Y-%m-%d %H:%M:%S')
        last_afupdatefile = dynamic_params.get_param('last_afupdatefile')
        data_change_time = max(last_switch_time, last_prepare_all_time, last_afupdatefile)
        last_run_time = dynamic_params.get_param('last_precalc_expected_thread_events_time')

        if not last_run_time or last_run_time < data_change_time:
            with log_run_time('update_expected_suburban_events', logger=log):
                precalc_all_expected_thread_events(last_run_time=last_run_time)
            dynamic_params.set_param('last_precalc_expected_thread_events_time', now())
    except OperationFailure as ex:
        log.exception(u'update_expected_suburban_events failed {}; {}'.format(ex.code, ex.details))
        raise
    except Exception:
        log.exception(u'update_expected_suburban_events failed')
        raise


def lock_aware_run():
    with lock('lock_update_expected_suburban_events', 'suburban_events_process',
              database_name=settings.SUBURBAN_EVENTS_DATABASE_NAME, timeout=1800), \
            script_context('update_expected_suburban_events_after_prepare_all'):
        run()


if __name__ == '__main__':
    lock_aware_run()
