# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging  # noqa

from django.conf import settings
from pymongo.errors import OperationFailure

from common.apps.suburban_events.scripts.update_movista_matched_cancels import update_movista_matched_cancels
from common.utils.lock import lock
from travel.rasp.library.python.common23.logging.scripts import script_context

log = logging.getLogger('update_movista_matched_cancels')


def run():
    try:
        update_movista_matched_cancels()
    except OperationFailure as ex:
        log.exception(u'update_movista_matched_cancels failed {};{}'.format(ex.code, ex.details))
        raise
    except Exception:
        log.exception(u'update_movista_matched_cancels failed')
        raise


def lock_aware_run():
    with lock('lock_update_movista_matched_cancels', 'suburban_events_process',
              database_name=settings.SUBURBAN_EVENTS_DATABASE_NAME), script_context('update_movista_matched_cancels'):
        run()


if __name__ == '__main__':
    lock_aware_run()
