# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging  # noqa

from django.conf import settings
from pymongo.errors import OperationFailure

from common.apps.suburban_events.scripts.update_suburban_events import update_all
from common.utils.lock import lock
from travel.rasp.library.python.common23.logging.scripts import script_context

log = logging.getLogger('update_suburban_events')


def run():
    try:
        update_all()
    except OperationFailure as ex:
        log.exception(u'update_all failed {};{}'.format(ex.code, ex.details))
        raise
    except Exception:
        log.exception(u'update_all failed')
        raise


def lock_aware_run():
    with lock('lock_update_suburban_events', 'suburban_events_process',
              database_name=settings.SUBURBAN_EVENTS_DATABASE_NAME), script_context('update_suburban_events'):
        run()


if __name__ == '__main__':
    lock_aware_run()
