PY2_LIBRARY(tasks)

OWNER(
    g:rasp-back
    lorekhov
)

IF(PYTHON2)
    PEERDIR(
        contrib/python/typing
    )
ENDIF()

PEERDIR(
    contrib/python/APScheduler
    contrib/python/Flask
    contrib/python/ujson

    yt/yt/python/yt_yson_bindings

    ydb/public/sdk/python
    yql/library/python

    travel/rasp/library/python/common
    travel/library/python/entrypoint
    travel/rasp/library/python/route_search
    travel/rasp/library/python/stationschedule
)

PY_SRCS(
    app.py
    settings.py
    tests_settings.py

    api_public/__init__.py
    api_public/api_public_stations_list.py
    min_prices/__init__.py
    min_prices/every_day_run.py
    min_prices/every_night_run.py
    min_prices/min_prices_yt_cleaner.py
    min_prices/direct_feeds.py
    min_prices/pack_avia_prices.py
    min_prices/pack_min_avia_prices.py
    min_prices/yt_min_avia_price.py
    min_prices/yt_min_train_prices.py
    min_prices/yt_to_mongo.py
    monitoring/load_rasp_project.py
    monitoring/suburban_events.py
    nearest_suburbans/__init__.py
    nearest_suburbans/base_generator.py
    nearest_suburbans/data_classes.py
    nearest_suburbans/main_stations_generator.py
    nearest_suburbans/nearest_generator.py
    nearest_suburbans/update_nearest_all_suburbans.py
    nearest_suburbans/update_nearest_main_stations_suburbans.py
    nearest_suburbans/update_nearest_suburbans.py
    platforms/__init__.py
    platforms/clean_dynamic_platforms.py
    platforms/update_dynamic_platforms.py
    suburban_events/__init__.py
    suburban_events/clean_suburban_events.py
    suburban_events/update_company_crashes.py
    suburban_events/update_expected_suburban_events.py
    suburban_events/update_expected_suburban_events_after_prepare_all.py
    suburban_events/update_movista_matched_cancels.py
    suburban_events/update_movista_raw_cancels.py
    suburban_events/update_suburban_events.py
    utils/__init__.py
    utils/chunker.py
    utils/shrinked_timezones.py
    yt_table_schema.py
)

END()

RECURSE(
    bin/app
)

RECURSE_FOR_TESTS(
    tests
    bin/tests
)
