# coding: utf8
"""
Устанавливаем схемы наших таблиц в YT, чтобы с ними можно было удобно работать через yql.

https://st.yandex-team.ru/RASPEXPORT-190
"""

from datetime import datetime, timedelta  # noqa: I

import yt.wrapper
from django.conf import settings

from common.utils.date import daterange
from common.utils.lock import lock
from common.data_api.yt.instance import update_yt_wrapper_config


USER_SEARCH_LOG_SCHEMA = [
    {'name': '_stbx', 'type': 'string'},
    {'name': 'adults', 'type': 'string'},
    {'name': 'children', 'type': 'string'},
    {'name': 'eventtime', 'type': 'string'},
    {'name': 'from_id', 'type': 'string'},
    {'name': 'geoid', 'type': 'string'},
    {'name': 'infants', 'type': 'string'},
    {'name': 'iso_eventtime', 'type': 'string'},
    {'name': 'klass', 'type': 'string'},
    {'name': 'national_version', 'type': 'string'},
    {'name': 'passportuid', 'type': 'string'},
    {'name': 'referer', 'type': 'string'},
    {'name': 'request_id', 'type': 'string'},
    {'name': 'return_date', 'type': 'string'},
    {'name': 'service', 'type': 'string'},
    {'name': 'source_uri', 'type': 'string'},
    {'name': 'subkey', 'type': 'string'},
    {'name': 'to_id', 'type': 'string'},
    {'name': 'transfer_count', 'type': 'string'},
    {'name': 'transport_type', 'type': 'string'},
    {'name': 'tskv_format', 'type': 'string'},
    {'name': 'unixtime', 'type': 'string'},
    {'name': 'userip', 'type': 'string'},
    {'name': 'when', 'type': 'string'},
    {'name': 'yandexuid', 'type': 'string'},
    {'name': 'user_type', 'type': 'string'},
    {'name': 'device_uuid', 'type': 'string'},
]


def main():
    update_yt_wrapper_config()

    # берем несколько дней, чтобы не запариваться за возможные падения скрипта и таймзоны сервера/ытя
    now = datetime.now()
    for dt in daterange(now - timedelta(days=5), now + timedelta(days=2)):
        dt_str = dt.strftime('%Y-%m-%d')
        table = settings.YT_SEARCH_LOG_PATH + '/{}'.format(dt_str)
        if yt.wrapper.exists(table):
            yt.wrapper.set_attribute(table, '_read_schema', USER_SEARCH_LOG_SCHEMA)
            yt.wrapper.set_attribute(table + '/@_read_schema', 'strict', 'false')


def run():
    with lock('yt_table_schema'):
        main()


if __name__ == '__main__':
    run()
