#!/bin/bash
export PATH=/opt/nodejs/0.10/bin:$PATH
export NODE_PATH=/opt/nodejs/0.10/lib:$NODE_PATH

cd /app/markup && YENV=production make
cd /app/static && YENV=production make

set -ex

PKG_VERSION=v42

PAGES=`find /app/markup/desktop.bundles/* -type d -printf '%f\n'`

destination=/static

#
# old static
#

STATIC_DIR=$destination/markup

install -d $STATIC_DIR

# Images & fonts
cp -RT /app/markup/old $destination/old

for page in $PAGES; do
    install -d $STATIC_DIR/desktop.bundles/$page; \
    install \
        /app/markup/desktop.bundles/$page/_$page.css \
        /app/markup/desktop.bundles/$page/_$page.*.pub.js \
        $STATIC_DIR/desktop.bundles/$page/; \
done;

#
# new static
#

NEW_PAGES=`find /app/static/touch.bundles/* -maxdepth 0 -type d ! -path . -printf '%f\n'`
NEW_STATIC_DIR=$destination/static

install -d $NEW_STATIC_DIR

# Images & fonts
cp -RT /app/static/new $destination/new

# cp css/js
for page in $NEW_PAGES; do
    install -d $NEW_STATIC_DIR/touch.bundles/$page; \
    install \
        /app/static/touch.bundles/$page/_$page.css \
        /app/static/touch.bundles/$page/_$page.*.pub.js \
        $NEW_STATIC_DIR/touch.bundles/$page/; \
done;

#
# common
#

# Misc images
cp -RT /app/markup/i $STATIC_DIR/i
