#!/bin/bash
export PATH=/opt/nodejs/0.10/bin:$PATH
export NODE_PATH=/opt/nodejs/0.10/lib:$NODE_PATH

npm install bower - g

YENV=production make -C ./markup
YENV=production make -C ./static

set -ex

retry() {
    count=${count:-2}
    sleep=${sleep:-3}
    for(( i=1; i<=count; i++ )); do
        echo --== try $i: "$@"
        "$@" && return 0 || echo --== try $i error && sleep $sleep
    done
    return 1
}

# sync with s3
virtualenv ./env
source env/bin/activate
retry pip install awscli~=1.15.0
APP_PREFIX=s/touch

count=3 retry aws s3 --endpoint-url=$AWS_URL sync ./markup/old/ s3://$AWS_BUCKET/$APP_PREFIX/old/
count=3 retry aws s3 --endpoint-url=$AWS_URL sync ./static/new/ s3://$AWS_BUCKET/$APP_PREFIX/new/
