# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from settings import *
from common.settings.configuration import Configuration
from common.settings.utils import configure_raven, get_app_version
from travel.rasp.library.python.common23.logging.configure import configure_default_logging

PACKAGE_NAME = 'yandex-rasp-touch'
ENABLE_PROD_NEW_MAINTENANCE = True

LOG_PATH = '/var/log/app/'

class TouchConfigurator(BaseConfigurator):
    def apply_base(self, settings):
        self.setup_logging(settings)

    def apply_production(self, settings):
        configure_raven(settings, 'touch')

    def apply_testing(self, settings):
        configure_raven(settings, 'touch')

    def setup_logging(self, settings, base_log_level=None):
        settings['LOGGING'] = configure_default_logging(settings, base_log_level=base_log_level)

Configuration.configurator_classes += [TouchConfigurator]

Configuration().apply(globals())

PKG_VERSION = get_app_version()

markup_suffix = ''
if YANDEX_ENVIRONMENT_TYPE == 'testing':
    markup_suffix = '-testing'

MARKUP_ROOT = os.getenv('RASP_TOUCH_MARKUP_ROOT', os.path.join(os.path.dirname(__file__), 'markup'))
with open('/app/markup-version', 'r') as f:
    version = f.readline().strip()
    MARKUP_URL = 'https://yastatic.net/s3/rasp/s/touch/%s/' % version


MEDIA_URL = '//yastat.net/s3/rasp/media/'

CACHEROOT = '/%s/%s/' % (PACKAGE_NAME, PKG_VERSION)

TVM_DESTINATIONS = ['TVM_BLACKBOX', 'TVM_BLACKBOX_MIMINO']

if YANDEX_ENVIRONMENT_TYPE == 'production':
    RASP_DOMAIN = 'rasp.yandex.ru'
    RASP_URL = 'http://%s/' % RASP_DOMAIN
    TIME_CORRECTION_URL = RASP_URL + 'time/correction/'

    ENVIRONMENT = 'production'

    SUGGESTS_DOMAIN = 'suggests.rasp.yandex.net'

    SUPPORTED_HOSTS = ['t.rasp.yandex.%s' % domain for domain in SUPPORTED_DOMAINS]

    TVM_SERVICE_ID = 2017309

elif YANDEX_ENVIRONMENT_TYPE == 'testing':
    SUGGESTS_DOMAIN = 'testing.suggests.rasp.common.yandex.net'

    DOMAIN_NAME = 't.rasp.tst.rasp.yandex.ru'
    TOUCH_URL = 'https://' + DOMAIN_NAME

    RASP_DOMAIN = 'rasp.tst.rasp.yandex.ru'
    RASP_URL = 'http://{}/'.format(RASP_DOMAIN)

    NATIONAL_RASP_DOMAINS = {
        'ru': 'rasp.tst.rasp.yandex.ru',
        'ua': 'rasp.tst.rasp.yandex.ua',
        'by': 'rasp.tst.rasp.yandex.by',
        'kz': 'rasp.tst.rasp.yandex.kz',
        'uz': 'rasp.tst.rasp.yandex.uz',
    }

    NATIONAL_DOMAIN_MAP = {
        'ru': 't.rasp.tst.rasp.yandex.ru',
        'ua': 't.rasp.tst.rasp.yandex.ua',
        'by': 't.rasp.tst.rasp.yandex.by',
        'kz': 't.rasp.tst.rasp.yandex.kz',
        'uz': 't.rasp.tst.rasp.yandex.uz',
    }

    SUPPORTED_HOSTS = ['t.rasp.tst.rasp.yandex.{}'.format(domain) for domain in SUPPORTED_DOMAINS]

    TVM_SERVICE_ID = 2017307
    TVM_BLACKBOX = 239

elif YANDEX_ENVIRONMENT_TYPE == 'stress':
    DISABLE_YAUTH = True

    RASP_DOMAIN = 'rasp.rasp-front01g.load.rasp.yandex.net'
    SUGGESTS_DOMAIN = 'testing.suggests.rasp.common.yandex.net'

    NATIONAL_RASP_DOMAINS = {domain: RASP_DOMAIN for domain in TOUCH_NATIONAL_DOMAINS}

    RASP_URL = 'http://%s/' % RASP_DOMAIN

    DOMAIN_NAME = 't.rasp.rasp-front01g.load.rasp.yandex.ru'
    TOUCH_URL = 'http://' + DOMAIN_NAME

    SUPPORTED_HOSTS = ['rasp.rasp-front01g.load.rasp.yandex.%s' % domain for domain in SUPPORTED_DOMAINS]

MEDIA_URL = os.getenv('RASP_MEDIA_URL', MEDIA_URL)
SEARCH_LOG = os.path.join(LOG_PATH, 'marketstat/search.log')
REDIR_LOG = os.path.join(LOG_PATH, 'marketstat/order/redir.log')
PLANE_REDIR_LOG = os.path.join(LOG_PATH, 'marketstat/order/plane_redir.log')
BUS_REDIR_LOG = os.path.join(LOG_PATH, 'marketstat/order/bus_redir.log')
AUCTION_REDIR_LOG = os.path.join(LOG_PATH, 'marketstat/order/auction_redir.log')
RASP_USERS_SEARCH_LOG = os.path.join(LOG_PATH, 'yt/search.log')
