# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from django import forms
from common.models.geo import Settlement


class CityForm(object):
    def __init__(self, request, enable_foreign_logic=False):
        self.default_city = request.client_city
        self.enable_foreign_logic = enable_foreign_logic

        try:
            self.city_id = forms.IntegerField().clean(request.GET.get('city', None))
        except forms.ValidationError:
            self.city_id = None

        try:
            self.city_geo_id = forms.IntegerField().clean(request.GET.get('city_geo_id', None))
        except forms.ValidationError:
            self.city_geo_id = None

        self.city = self._get_city()

    def _get_city(self):
        # морда будет передавать нам город по гео-базе
        if self.city_geo_id:
            try:
                return Settlement.objects.get(_geo_id=self.city_geo_id)
            except Settlement.DoesNotExist:
                pass

        # вполне возможно, что id города нам кто-то будет передавать по расписанческой id
        if self.city_id:
            try:
                return Settlement.hidden_manager.get(pk=self.city_id)
            except Settlement.DoesNotExist:
                pass

        # эта логика необходима для ботов, чтобы им подставлялась москва.
        if self.enable_foreign_logic and self.default_city.is_foreign():
            return Settlement.get_default_city()

        return self.default_city
