module.exports = function (config) {
    config.setLanguages(["ru", "en", "tr", "uk"]);

    var browserSupport = [
        'iOS >= 5',
        'Android >= 2',
        'Chrome >= 35',
        'OperaMobile 12',
        'Opera 12',
        'Firefox >= 15',
        'IE >= 8'
    ];

    config.nodes('desktop.bundles/*');

    config.mode("development", function () {
        config.nodeMask(/desktop.bundles\/.*/, function(nodeConfig) {
            nodeConfig.addTechs([
                [ require("enb/techs/file-copy"), { sourceTarget: "?.{lang}.pub.js", destTarget: "_?.{lang}.pub.js" } ],
                [ require("enb/techs/file-copy"), { sourceTarget: "?.ap.css", destTarget: "_?.css" } ]
            ]);
        });
    });

    config.mode("production", function () {
        config.nodeMask(/desktop.bundles\/.*/, function(nodeConfig) {
            nodeConfig.addTechs([
                [ require("enb/techs/borschik"), { sourceTarget: "?.ap.css", destTarget: "_?.css", minify: true, freeze: true } ],
                [ require("enb/techs/borschik"), { sourceTarget: "?.{lang}.pub.js", destTarget: "_?.{lang}.pub.js" , minify: true, freeze: false} ]
            ]);
        });
    });

    config.nodeMask(/desktop.bundles\/.*/, function(nodeConfig) {
        nodeConfig.addTechs([
            [ require("enb/techs/levels"), { levels: getLevels() } ],
            [ require("enb/techs/file-provider"), { target: "?.bemjson.js" } ],
            require("enb/techs/bemdecl-from-bemjson"),
            require("enb/techs/deps-old"),
            require("enb/techs/files"),
            require("enb-xjst/techs/bemhtml"),
            require("enb/techs/css"),
            [require('enb-autoprefixer/techs/css-autoprefixer'), {
                sourceTarget: "?.css",  // Source CSS
                destTarget: "?.ap.css", // Target
                browserSupport: browserSupport
            }],
            require("enb/techs/js"),
            require('enb/techs/priv-js'),
            [ require("enb/techs/i18n-merge-keysets"), { lang: "all" }],
            [ require("enb/techs/i18n-merge-keysets"), { lang: "{lang}" }],
            [ require("./techs/i18n-lang-js"), { lang: "all" } ],
            [ require("./techs/i18n-lang-js"), { lang: "{lang}" } ],
            [ require('./techs/html-from-bemjson-i18n-sync'), { lang: '{lang}'}],
            [ require('./techs/pub-js-i18n'), {
                lang: '{lang}'
            } ],
            [ require('enb/techs/priv-js-i18n-all'), {
                langTargets: ['all'].concat(config.getLanguages()).map(function(lang) {return '?.lang.' + lang + '.js'})
            } ]
        ]);
        nodeConfig.addTargets(["_?.css", "?.{lang}.pub.js", "_?.{lang}.pub.js", "?.all.priv.js", "?.{lang}.html"]);

        function getLevels() {
            return [
                {"path": "bem-bl/blocks-common", "check": false},
                {"path": "bem-bl/blocks-touch", "check": false},

                {"path": "lego/blocks-common", "check": false},
                {"path": "lego/blocks-touch", "check": false},
                {"path": "lego/blocks-touch-phone", "check": false},

                {"path": "bem-components/common.blocks", "check": false},
                {"path": "bem-components/touch.blocks", "check": false},
                {"path": "bem-components/touch-phone.blocks", "check": false},

                {"path": "islands-media/common.blocks", "check": false},

                {"path": "islands-page/common.blocks", "check": false},
                {"path": "islands-page/touch-phone.blocks", "check": false},

                {"path": "islands-components/common.blocks", "check": false},
                {"path": "islands-components/touch.blocks", "check": false},
                {"path": "islands-components/touch-phone.blocks", "check": false},

                {"path": "islands-user/common.blocks", "check": false},
                {"path": "islands-user/touch-phone.blocks", "check": false},

                {"path": "islands-search/common.blocks", "check": false},
                {"path": "islands-search/touch.blocks", "check": false},
                {"path": "islands-search/touch-phone.blocks", "check": false},

                {"path": "touch-blocks/touch.blocks", "check": false},
                {"path": "desktop.blocks", "check": true}
            ].map(function (l) {
                return config.resolvePath(l);
            });
        }
    });
}
